/*
 * Decompiled with CFR 0.152.
 */
package com.djinfinite.manors_bounty;

import com.djinfinite.manors_bounty.registries.ModBlockEntities;
import com.djinfinite.manors_bounty.registries.ModBlocks;
import com.djinfinite.manors_bounty.registries.ModEntities;
import com.djinfinite.manors_bounty.registries.ModFeatures;
import com.djinfinite.manors_bounty.registries.ModFluidTypes;
import com.djinfinite.manors_bounty.registries.ModFluids;
import com.djinfinite.manors_bounty.registries.ModItems;
import com.djinfinite.manors_bounty.registries.ModMenus;
import com.djinfinite.manors_bounty.registries.ModMobEffects;
import com.djinfinite.manors_bounty.registries.ModParticleTypes;
import com.djinfinite.manors_bounty.registries.ModPotions;
import com.djinfinite.manors_bounty.registries.ModSounds;
import com.djinfinite.manors_bounty.registries.ModTabs;
import com.djinfinite.manors_bounty.registries.WorldGen;
import com.djinfinite.manors_bounty.world.features.StructureFeature;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.DatapackBuiltinEntriesProvider;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

@Mod(value="manors_bounty")
public class ManorsBountyMod {
    public static final String MOD_ID = "manors_bounty";
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel PACKET_HANDLER = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("manors_bounty", "manors_bounty"), () -> "1", "1"::equals, "1"::equals);
    private static int messageID = 0;
    private static final Collection<AbstractMap.SimpleEntry<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<AbstractMap.SimpleEntry<Runnable, Integer>>();

    public ManorsBountyMod() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        MinecraftForge.EVENT_BUS.register((Object)this);
        modBus.addListener(this::gatherData);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ModFeatures.FEATURES.register(bus);
        ModSounds.REGISTRY.register(bus);
        ModBlocks.REGISTRY.register(bus);
        ModBlockEntities.REGISTRY.register(bus);
        ModItems.REGISTRY.register(bus);
        ModEntities.REGISTRY.register(bus);
        ModTabs.REGISTRY.register(bus);
        StructureFeature.REGISTRY.register(bus);
        ModMobEffects.REGISTRY.register(bus);
        ModPotions.REGISTRY.register(bus);
        ModParticleTypes.REGISTRY.register(bus);
        ModMenus.REGISTRY.register(bus);
        ModFluids.REGISTRY.register(bus);
        ModFluidTypes.REGISTRY.register(bus);
    }

    public static <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        PACKET_HANDLER.registerMessage(messageID, messageType, encoder, decoder, messageConsumer);
        ++messageID;
    }

    public static void queueServerWork(int tick, Runnable action) {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            workQueue.add(new AbstractMap.SimpleEntry<Runnable, Integer>(action, tick));
        }
    }

    public static ResourceLocation createModResourceLocation(String string) {
        return new ResourceLocation(MOD_ID, string);
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ArrayList actions = new ArrayList();
            workQueue.forEach(work -> {
                work.setValue((Integer)work.getValue() - 1);
                if ((Integer)work.getValue() == 0) {
                    actions.add(work);
                }
            });
            actions.forEach(e -> ((Runnable)e.getKey()).run());
            workQueue.removeAll(actions);
        }
    }

    private void gatherData(GatherDataEvent event) {
        PackOutput output = event.getGenerator().getPackOutput();
        event.getGenerator().addProvider(event.includeServer(), (DataProvider)new DatapackBuiltinEntriesProvider(output, event.getLookupProvider(), WorldGen.BUILDER, Set.of(MOD_ID)));
    }
}

